CREATE INDEX IF NOT EXISTS siv__exp_sequence ON search_index_view (_experiment_id, _sequence_id) WHERE _sequence_id IS NOT NULL;
CREATE INDEX IF NOT EXISTS siv__exp_mutant ON search_index_view (_experiment_id, _mutant_id) WHERE _mutant_id IS NOT NULL;

CREATE INDEX IF NOT EXISTS siv__definite_order ON search_index_view (source_sequence_id, mutated_position__min NULLS FIRST, _mutant_id NULLS FIRST, _experiment_id);

-- === NumberVariable ===
-- SOURCE_SEQUENCE_ID - we don't order by this, therefore we create just one index for searching
CREATE INDEX IF NOT EXISTS siv_source_sequence_id ON search_index_view (source_sequence_id);
-- SEQUENCE_LENGTH
CREATE INDEX IF NOT EXISTS siv_sequence_length__asc ON search_index_view (sequence_length ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_sequence_length__desc ON search_index_view (sequence_length DESC NULLS LAST);

-- === BooleanVariable ===
-- IN_TUNNEL
CREATE INDEX IF NOT EXISTS siv_in_tunnel__asc ON search_index_view (in_tunnel ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_in_tunnel__desc ON search_index_view (in_tunnel DESC NULLS LAST);
-- IN_POCKET
CREATE INDEX IF NOT EXISTS siv_in_pocket__asc ON search_index_view (in_pocket ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_in_pocket__desc ON search_index_view (in_pocket DESC NULLS LAST);

-- === StringVariable ===
-- SEQUENCE - we don't order by this, therefore we create just one index for searching
CREATE INDEX IF NOT EXISTS siv__sequence_md5 ON search_index_view (_sequence_md5);

-- === ArrayNumberVariable ===
-- MUTATED_POSITION
CREATE INDEX IF NOT EXISTS siv_mutated_position ON search_index_view USING gin (mutated_position);
CREATE INDEX IF NOT EXISTS siv_mutated_position__avg__asc  ON search_index_view (mutated_position__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_mutated_position__avg__desc ON search_index_view (mutated_position__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_mutated_position__min ON search_index_view (mutated_position__min);
CREATE INDEX IF NOT EXISTS siv_mutated_position__max ON search_index_view (mutated_position__max);
-- CONSERVATION
CREATE INDEX IF NOT EXISTS siv_conservation ON search_index_view USING gin (conservation);
CREATE INDEX IF NOT EXISTS siv_conservation__avg__asc  ON search_index_view (conservation__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_conservation__avg__desc ON search_index_view (conservation__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_conservation__min ON search_index_view (conservation__min);
CREATE INDEX IF NOT EXISTS siv_conservation__max ON search_index_view (conservation__max);
-- B_FACTOR
CREATE INDEX IF NOT EXISTS siv_b_factor ON search_index_view USING gin (b_factor);
CREATE INDEX IF NOT EXISTS siv_b_factor__avg__asc  ON search_index_view (b_factor__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_b_factor__avg__desc ON search_index_view (b_factor__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_b_factor__min ON search_index_view (b_factor__min);
CREATE INDEX IF NOT EXISTS siv_b_factor__max ON search_index_view (b_factor__max);
-- DG
CREATE INDEX IF NOT EXISTS siv_dg ON search_index_view USING gin (dg);
CREATE INDEX IF NOT EXISTS siv_dg__avg__asc  ON search_index_view (dg__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_dg__avg__desc ON search_index_view (dg__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_dg__min ON search_index_view (dg__min);
CREATE INDEX IF NOT EXISTS siv_dg__max ON search_index_view (dg__max);
-- DDG
CREATE INDEX IF NOT EXISTS siv_ddg ON search_index_view USING gin (ddg);
CREATE INDEX IF NOT EXISTS siv_ddg__avg__asc  ON search_index_view (ddg__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_ddg__avg__desc ON search_index_view (ddg__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_ddg__min ON search_index_view (ddg__min);
CREATE INDEX IF NOT EXISTS siv_ddg__max ON search_index_view (ddg__max);
-- DOMAINOME_DDG
CREATE INDEX IF NOT EXISTS siv_domainome_ddg ON search_index_view USING gin (domainome_ddg);
CREATE INDEX IF NOT EXISTS siv_domainome_ddg__avg__asc  ON search_index_view (domainome_ddg__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_domainome_ddg__avg__desc ON search_index_view (domainome_ddg__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_domainome_ddg__min ON search_index_view (domainome_ddg__min);
CREATE INDEX IF NOT EXISTS siv_domainome_ddg__max ON search_index_view (domainome_ddg__max);
-- DOMAINOME_FITNESS
CREATE INDEX IF NOT EXISTS siv_domainome_fitness ON search_index_view USING gin (domainome_fitness);
CREATE INDEX IF NOT EXISTS siv_domainome_fitness__avg__asc  ON search_index_view (domainome_fitness__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_domainome_fitness__avg__desc ON search_index_view (domainome_fitness__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_domainome_fitness__min ON search_index_view (domainome_fitness__min);
CREATE INDEX IF NOT EXISTS siv_domainome_fitness__max ON search_index_view (domainome_fitness__max);
-- TM
CREATE INDEX IF NOT EXISTS siv_tm ON search_index_view USING gin (tm);
CREATE INDEX IF NOT EXISTS siv_tm__avg__asc  ON search_index_view (tm__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_tm__avg__desc ON search_index_view (tm__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_tm__min ON search_index_view (tm__min);
CREATE INDEX IF NOT EXISTS siv_tm__max ON search_index_view (tm__max);
-- DTM
CREATE INDEX IF NOT EXISTS siv_dtm ON search_index_view USING gin (dtm);
CREATE INDEX IF NOT EXISTS siv_dtm__avg__asc  ON search_index_view (dtm__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_dtm__avg__desc ON search_index_view (dtm__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_dtm__min ON search_index_view (dtm__min);
CREATE INDEX IF NOT EXISTS siv_dtm__max ON search_index_view (dtm__max);
-- PH
CREATE INDEX IF NOT EXISTS siv_ph ON search_index_view USING gin (ph);
CREATE INDEX IF NOT EXISTS siv_ph__avg__asc  ON search_index_view (ph__avg ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_ph__avg__desc ON search_index_view (ph__avg DESC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_ph__min ON search_index_view (ph__min);
CREATE INDEX IF NOT EXISTS siv_ph__max ON search_index_view (ph__max);

-- === ArrayStringVariable ===
-- SOURCE_AMINO_ACID
CREATE INDEX IF NOT EXISTS siv_source_amino_acid ON search_index_view USING gin (source_amino_acid);
CREATE INDEX IF NOT EXISTS siv_source_amino_acid__1st_asc  ON search_index_view ((source_amino_acid[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_source_amino_acid__1st_desc ON search_index_view ((source_amino_acid[1]) DESC NULLS LAST);
-- TARGET_AMINO_ACID
CREATE INDEX IF NOT EXISTS siv_target_amino_acid ON search_index_view USING gin (target_amino_acid);
CREATE INDEX IF NOT EXISTS siv_target_amino_acid__1st_asc  ON search_index_view ((target_amino_acid[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_target_amino_acid__1st_desc ON search_index_view ((target_amino_acid[1]) DESC NULLS LAST);
-- ACTIVE_SITE
CREATE INDEX IF NOT EXISTS siv_active_site ON search_index_view USING gin (active_site);
CREATE INDEX IF NOT EXISTS siv_active_site__1st_asc  ON search_index_view ((active_site[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_active_site__1st_desc ON search_index_view ((active_site[1]) DESC NULLS LAST);
-- BINDING_SITE
CREATE INDEX IF NOT EXISTS siv_binding_site ON search_index_view USING gin (binding_site);
CREATE INDEX IF NOT EXISTS siv_binding_site__1st_asc  ON search_index_view ((binding_site[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_binding_site__1st_desc ON search_index_view ((binding_site[1]) DESC NULLS LAST);
-- PROTEIN_NAME
CREATE INDEX IF NOT EXISTS siv_protein_name ON search_index_view USING gin (protein_name);
CREATE INDEX IF NOT EXISTS siv_protein_name__1st_asc  ON search_index_view ((protein_name[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_protein_name__1st_desc ON search_index_view ((protein_name[1]) DESC NULLS LAST);
-- ORGANISM
CREATE INDEX IF NOT EXISTS siv_organism ON search_index_view USING gin (organism);
CREATE INDEX IF NOT EXISTS siv_organism__1st_asc  ON search_index_view ((organism[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_organism__1st_desc ON search_index_view ((organism[1]) DESC NULLS LAST);
-- EC_NUMBER
CREATE INDEX IF NOT EXISTS siv_ec_number ON search_index_view USING gin (ec_number);
CREATE INDEX IF NOT EXISTS siv_ec_number__1st_asc  ON search_index_view ((ec_number[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_ec_number__1st_desc ON search_index_view ((ec_number[1]) DESC NULLS LAST);
-- UNIPROTKB
CREATE INDEX IF NOT EXISTS siv_uniprotkb ON search_index_view USING gin (uniprotkb);
CREATE INDEX IF NOT EXISTS siv_uniprotkb__1st_asc  ON search_index_view ((uniprotkb[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_uniprotkb__1st_desc ON search_index_view ((uniprotkb[1]) DESC NULLS LAST);
-- INTERPRO
CREATE INDEX IF NOT EXISTS siv_interpro ON search_index_view USING gin (interpro);
CREATE INDEX IF NOT EXISTS siv_interpro__1st_asc  ON search_index_view ((interpro[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_interpro__1st_desc ON search_index_view ((interpro[1]) DESC NULLS LAST);
-- PUBLICATION_DOI_PMID
CREATE INDEX IF NOT EXISTS siv_publication_doi_pmid ON search_index_view USING gin (publication_doi_pmid);
CREATE INDEX IF NOT EXISTS siv_publication_doi_pmid__1st_asc  ON search_index_view ((publication_doi_pmid[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_publication_doi_pmid__1st_desc ON search_index_view ((publication_doi_pmid[1]) DESC NULLS LAST);
-- DATASET
CREATE INDEX IF NOT EXISTS siv_dataset ON search_index_view USING gin (dataset);
CREATE INDEX IF NOT EXISTS siv_dataset__1st_asc  ON search_index_view ((dataset[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_dataset__1st_desc ON search_index_view ((dataset[1]) DESC NULLS LAST);
-- MEASURE
CREATE INDEX IF NOT EXISTS siv_measure ON search_index_view USING gin (measure);
CREATE INDEX IF NOT EXISTS siv_measure__1st_asc  ON search_index_view ((measure[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_measure__1st_desc ON search_index_view ((measure[1]) DESC NULLS LAST);
-- WWPDB
CREATE INDEX IF NOT EXISTS siv_wwpdb ON search_index_view USING gin (wwpdb);
CREATE INDEX IF NOT EXISTS siv_wwpdb__1st_asc  ON search_index_view ((wwpdb[1]) ASC NULLS LAST);
CREATE INDEX IF NOT EXISTS siv_wwpdb__1st_desc ON search_index_view ((wwpdb[1]) DESC NULLS LAST);

-- _fulltext
CREATE INDEX IF NOT EXISTS siv__fulltext ON search_index_view USING gin (_fulltext);
